/*
 * Copyright (C) 2012-2025 Japan Smartphone Security Association
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jssec.android.autofillframework.autofillapp;

public class Util {
    private static int MIN_NAME_LEN = 1;
    private static int MAX_NAME_LEN = 16;
    private static int MIN_PASSWORD_LEN = 8;
    private static int MAX_PASSWORD_LEN = 16;

    public static boolean validateUsername(String username) {
        //Validate security of data properly
        if (username == null || username.length() < MIN_NAME_LEN || username.length() > MAX_NAME_LEN) {
            return false;
        }
        return true;
    }

    public static boolean validatePassword(String password) {
        //Validate security of data properly
        if (password == null || password.length() < MIN_PASSWORD_LEN || password.length() > MAX_PASSWORD_LEN) {
            return false;
        }
        return true;
    }
    void printLog() {

    }
}
